unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TFormMain = class(TForm)
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    Panel1: TPanel;
    Label1: TLabel;
    LX: TLabel;
    Label3: TLabel;
    LY: TLabel;
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FormMouseWheel(Sender: TObject; Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FormPaint(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);

  private

  public
	 R1    : TRect;
	 R2    : TRect;
	 R3    : TRect;

    move1 : Boolean;
    move2 : Boolean;
    move3 : Boolean;

	 x1    : Integer;
	 y1    : Integer;
	 x2    : Integer;
	 y2    : Integer;

	 procedure getRect1Pos(var x1 : Integer; var y1 : Integer; var x2 : Integer; var y2 : Integer);
	 procedure getRect2Pos(var x1 : Integer; var y1 : Integer; var x2 : Integer; var y2 : Integer);
	 procedure getRect3Pos(var x1 : Integer; var y1 : Integer; var x2 : Integer; var y2 : Integer);

	 procedure rect_move(const newx : Integer; const newy : Integer; var Rect : TRect);

	 procedure rysuj_rect1();
	 procedure rysuj_rect2();
	 procedure rysuj_rect3();
  end;


var
  FormMain: TFormMain;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TFormMain.BitBtn1Click(Sender: TObject);
begin
	Close();
end;

procedure TFormMain.FormCreate(Sender: TObject);
begin
	move1 := false;
	move2 := false;
	move3 := false;

	R1    := Rect( 58,  58, 158, 158);
	R2    := Rect(223, 223, 323, 323);
	R3    := Rect(345, 345, 445, 445);
end;

procedure TFormMain.FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
	LX.Caption := IntToStr(X);
	LY.Caption := IntToStr(Y);
end;

procedure TFormMain.FormMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	getRect1Pos(x1, y1, x2, y2);

	if(((X >= x1) and (X <= x2)) and ((Y >= y1) and (Y <= y2))) then
   begin
		move1 := true;
   end;

	getRect2Pos(x1, y1, x2, y2);
	if(((X >= x1) and (X <= x2)) and ((Y >= y1) and (Y <= y2))) then
   begin
		move2 := true;
   end;

	getRect3Pos(x1, y1, x2, y2);
	if(((X >= x1) and (X <= x2)) and ((Y >= y1) and (Y <= y2))) then
   begin
		move3 := true;
   end;
end;

procedure TFormMain.FormMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   if move1 then
   begin
   	rect_move(X, Y, R1);
		move1 := false;
   end;

   if move2 then
   begin
   	rect_move(X, Y, R2);
		move2 := false;
   end;

   if move3 then
   begin
   	rect_move(X, Y, R3);
		move3 := false;
   end;
end;

procedure TFormMain.FormMouseWheel(Sender: TObject; Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
begin
	ShowMessage('Krcisz rolk');
end;

procedure TFormMain.FormPaint(Sender: TObject);
begin
	rysuj_rect1();
	rysuj_rect2();
	rysuj_rect3();
end;

procedure TFormMain.getRect1Pos(var x1 : Integer; var y1 : Integer; var x2 : Integer; var y2 : Integer);
begin
	// aktualne pooenie ramki  R1
	x1 := R1.Left;
   y1 := R1.Top;
   x2 := R1.Right;
   y2 := R1.Bottom;
end;

procedure TFormMain.getRect2Pos(var x1 : Integer; var y1 : Integer; var x2 : Integer; var y2 : Integer);
begin
	// aktualne pooenie ramki  R2
	x1 := R2.Left;
   y1 := R2.Top;
   x2 := R2.Right;
   y2 := R2.Bottom;
end;

procedure TFormMain.getRect3Pos(var x1 : Integer; var y1 : Integer; var x2 : Integer; var y2 : Integer);
begin
	// aktualne pooenie ramki  R3
	x1 := R3.Left;
   y1 := R3.Top;
   x2 := R3.Right;
   y2 := R3.Bottom;
end;

procedure TFormMain.rysuj_rect1();
var
	kolor : TColor;

begin
	kolor              := Canvas.Pen.Color;
	Canvas.Pen.Color   := clWhite;
	Canvas.Brush.Color := clBlue;
	Canvas.Rectangle(R1);
	Canvas.Pen.Color := kolor;
end;

procedure TFormMain.rysuj_rect2();
var
	kolor : TColor;

begin
	kolor              := Canvas.Pen.Color;
	Canvas.Pen.Color   := clWhite;
	Canvas.Brush.Color := clYellow;
	Canvas.Rectangle(R2);
	Canvas.Pen.Color := kolor;
end;

procedure TFormMain.rysuj_rect3();
var
	kolor : TColor;

begin
	kolor              := Canvas.Pen.Color;
	Canvas.Pen.Color   := clWhite;
	Canvas.Brush.Color := clSkyBlue;
	Canvas.Rectangle(R3);
	Canvas.Pen.Color := kolor;
end;

procedure TFormMain.rect_move(const newx, newy: Integer; var Rect: TRect);
var
	k        : Double;
   h        : Integer;
   w        : Integer;
   oldKolor : TColor;

begin
	// wskanik myszy wskazuje jedynie nowe pooenie grnego lewego rogu
   if move1 then
   begin
	   getRect1Pos(x1, y1, x2, y2);
   end;

   if move2 then
   begin
   	getRect2Pos(x1, y1, x2, y2);
   end;

   if move3 then
   begin
   	getRect3Pos(x1, y1, x2, y2);
   end;

   oldKolor := Canvas.Brush.Color;

   h := y2 - y1;	// wysoko
   w := x2 - x1;	// szeroko

	x1 := newx;
   y1 := newy;
   x2 := x1 + w;
   y2 := y1 + h;

   Rect.Left   := x1;
   Rect.Top    := y1;
   Rect.Right  := x2;
   Rect.Bottom := y2;

	Canvas.Brush.Color := oldKolor;

   Invalidate();
end;

end.

